/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 11:55:29 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "general_private_cdsafewindir.h"
#include "libmatlbm.h"
#include "libmmfile.h"
static mxArray * _mxarray0_;

static mxChar _array2_[2] = { 'c', 'd' };
static mxArray * _mxarray1_;

static mxChar _array4_[6] = { 'w', 'i', 'n', 'd', 'i', 'r' };
static mxArray * _mxarray3_;

void InitializeModule_general_private_cdsafewindir(void) {
    _mxarray0_ = mclInitializeCharVector(0, 0, (mxChar *)NULL);
    _mxarray1_ = mclInitializeString(2, _array2_);
    _mxarray3_ = mclInitializeString(6, _array4_);
}

void TerminateModule_general_private_cdsafewindir(void) {
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mgeneral_private_cdsafewindir(int nargout_);

_mexLocalFunctionTable _local_function_table_general_private_cdsafewindir
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfGeneral_private_cdsafewindir" contains the normal interface
 * for the "general/private/cdsafewindir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\private\cdsafewindir.m" (lines 1-29).
 * This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfGeneral_private_cdsafewindir(void) {
    int nargout = 1;
    mxArray * cwd = NULL;
    mlfEnterNewContext(0, 0);
    cwd = Mgeneral_private_cdsafewindir(nargout);
    mlfRestorePreviousContext(0, 0);
    return mlfReturnValue(cwd);
}

/*
 * The function "mlxGeneral_private_cdsafewindir" contains the feval interface
 * for the "general/private/cdsafewindir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\private\cdsafewindir.m" (lines 1-29).
 * The feval function calls the implementation version of
 * general/private/cdsafewindir through this function. This function processes
 * any input arguments and passes them to the implementation version of the
 * function, appearing above.
 */
void mlxGeneral_private_cdsafewindir(int nlhs,
                                     mxArray * plhs[],
                                     int nrhs,
                                     mxArray * prhs[]) {
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: general/private/cdsafewindir Line: 15 "
            "Column: 1 The function \"general/private/cdsafewindir\" was "
            "called with more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 0) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: general/private/cdsafewindir Line: 15 "
            "Column: 1 The function \"general/private/cdsafewindir\" was "
            "called with more than the declared number of inputs (0)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mplhs[0] = Mgeneral_private_cdsafewindir(nlhs);
    mlfRestorePreviousContext(0, 0);
    plhs[0] = mplhs[0];
}

/*
 * The function "Mgeneral_private_cdsafewindir" is the implementation version
 * of the "general/private/cdsafewindir" M-function from file
 * "c:\matlab65\toolbox\matlab\general\private\cdsafewindir.m" (lines 1-29). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * % CDSAFEWINDIR. Change to safe directory in Windows when UNC path cause failures
 * % This is to check and see if the dos command is working.  In Win95
 * % if the current directory is a deeply nested directory or sometimes
 * % for TAS served file systems, the output pipe does not work.  The 
 * % solution is to make the current directory safe, %windir% and restore
 * % it afterwards.  The test is the cd command. 
 * % [cwd] = cdsafewindir
 * % Return:
 * %        cwd: string defining path of current working directory
 * 
 * %  JP Barnard
 * %  Copyright 1984-2002 The MathWorks, Inc.
 * %  $Revision: 1.3 $ $Date: 2002/04/08 20:51:29 $
 * %-------------------------------------------------------------------------------
 * function [cwd] = cdsafewindir
 */
static mxArray * Mgeneral_private_cdsafewindir(int nargout_) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(
          &_local_function_table_general_private_cdsafewindir);
    mxArray * cwd = NULL;
    mxArray * ans = NULL;
    mxArray * tmp = NULL;
    /*
     * %-------------------------------------------------------------------------------
     * cwd = '';
     */
    mlfAssign(&cwd, _mxarray0_);
    /*
     * 
     * try % test for MS DOS related unsafe directories.
     */
    mlfTry {
        /*
         * [tmp,tmp]=dos('cd'); % CD should return no message if in a safe directory.
         */
        mlfAssign(&tmp, mlfDos(&tmp, _mxarray1_, NULL));
    /*
     * catch % catch MS DOS file handling errors, related to unsafe directory
     */
    } mlfCatch {
        /*
         * cwd = pwd; % store current directory
         */
        mlfAssign(&cwd, mlfPwd());
        /*
         * cd(getenv('windir')); % change to safe directory (OS root directory)
         */
        mclAssignAns(&ans, mlfNCd(0, mlfGetenv(_mxarray3_)));
    /*
     * end
     */
    } mlfEndCatch
    mclValidateOutput(cwd, 1, nargout_, "cwd", "general/private/cdsafewindir");
    mxDestroyArray(tmp);
    mxDestroyArray(ans);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return cwd;
    /*
     * %-------------------------------------------------------------------------------
     * return
     * % end of CDSAFEWINDIR
     * %===============================================================================
     */
}
